package gov.va.med.mhv.bluebutton.transfer;

import gov.va.med.mhv.common.api.enumeration.ReportTypeEnum;

import java.io.Serializable;

import com.fasterxml.jackson.annotation.JsonIgnore;

public class BlueButtonReportDTO implements Serializable {
	private static final long serialVersionUID = 1295581581581515l;
	
	Long reportId;
	String filename;
	Long filesize;
	ReportTypeEnum type;
	
	public String getFilename() {
		return filename;
	}
	
	public void setFilename(String filename) {
		this.filename = filename;
	}
	
	public String getType() {
		return type.getType();
	}

	public void setType(ReportTypeEnum type) {
		this.type = type;
	}

	/**
	 * PDF size is computed by: (fileSize*5)+21658L
	 */
	public Long getFilesize() {
		return filesize;
	}
	
	public String getFilesizeString() {
		return String.valueOf(filesize/1024) + " KB";
	}
	public void setFilesizeString(String s) {
		//ignore 
	}
	
	public void setFilesize(Long filesize) {
		this.filesize = filesize;
	}

	public Long getReportId() {
		return reportId;
	}

	public void setReportId(Long reportId) {
		this.reportId = reportId;
	}
	
//	static public void main(String v[]) {
//		BlueButtonReportDTO d = new BlueButtonReportDTO();
//		d.setFilesize(751820L);
//		System.out.println(d.getFilesizeString());
//	}
}
